/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.TLDParser;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class TLDManager {
    private static final String TRACE_MASKT = "XJSPTLMT";
    private static final String TRACE_MASKF = "XJSPTLMF";
    private static Map tldManagerMap = new HashMap();
    TagLibraryInfo[] tlds;
    Map uriToTagLibInfo;

    public static synchronized TLDManager getTLDManager(ServletContext servletContext) throws JspException, IOException {
        TLDManager tldManager = (TLDManager)tldManagerMap.get(servletContext.getServletContextName());
        if (tldManager == null) {
            tldManager = new TLDManager(servletContext);
            tldManagerMap.put(servletContext.getServletContextName(), tldManager);
        }
        return tldManager;
    }

    private TLDManager(ServletContext servletContext) throws JspException, IOException {
        this.discoverAndParseTLDs(servletContext);
    }

    private void discoverAndParseTLDs(ServletContext servletContext) throws JspException, IOException {
        if (this.tlds != null) {
            return;
        }
        try {
            String webinf = servletContext.getRealPath("/WEB-INF");
            if (webinf == null) {
                throw new JspException("Cannot locate WEB-INF directory for context \"" + servletContext.getServletContextName() + "\".");
            }
            File webinfDir = new File(webinf);
            File[] tldFiles = webinfDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".tld");
                }
            });
            this.tlds = new TagLibraryInfo[tldFiles.length];
            this.uriToTagLibInfo = new HashMap();
            int i = 0;
            while (i < tldFiles.length) {
                TagLibraryInfo info;
                File tldFile = tldFiles[i];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(tldFile));
                Trace.trace(TRACE_MASKF, "Parsing tld file \"" + tldFile.getPath() + "\" for context \"" + servletContext.getServletContextName() + "\"");
                this.tlds[i] = info = TLDParser.parseTLD(in);
                this.uriToTagLibInfo.put("/WEB-INF/" + tldFile.getName(), info);
                if (info.getURI() != null) {
                    this.uriToTagLibInfo.put(info.getURI(), info);
                }
                ++i;
            }
        }
        catch (JspException e) {
            Trace.trace(TRACE_MASKT, "Unexpected exception discovering and parsing TLD files for context \"" + servletContext.getServletContextName() + "\": " + (Object)((Object)e));
            Trace.trace(TRACE_MASKT, (Object)e);
            this.tlds = new TagLibraryInfo[0];
            throw e;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "Unexpected exception discovering and parsing TLD files for context \"" + servletContext.getServletContextName() + "\": " + e);
            Trace.trace(TRACE_MASKT, e);
            this.tlds = new TagLibraryInfo[0];
            throw e;
        }
    }

    public TagLibraryInfo getTagLibForURI(String uri) {
        return (TagLibraryInfo)this.uriToTagLibInfo.get(uri);
    }

    public static void initializeInBackground(final ServletContext servletContext) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    TLDManager.getTLDManager(servletContext);
                }
                catch (Exception e) {}
            }
        }, "Parsing custom tag library tld files for context \"" + servletContext.getServletContextName() + "\"");
        thread.setDaemon(true);
        thread.start();
    }
}

